@extends('Frontend.Layouts.app')

@section('title')
    Loma
@endsection

@section('content')
    <!-- start header area -->
    <header class="header--sticky header-one header-four">
        <!-- Top Orange Section -->
        <div class="header-main-one" style="background-color: #e18b14">
            <div class="container py-3">
                <div class="d-flex flex-wrap justify-content-between align-items-center gap-3">
                    <!-- Logo Area (Left) -->
                    <div class="d-flex align-items-center gap-3 flex-wrap">
                        <a class="thumbnail" href="{{ route('home') }}">
                            <img src="{{ asset('assets/images/logo/loma-logo.png') }}" alt="Logo" style="height: 90px;">
                        </a>
                        <a class="thumbnail" href="{{ route('home') }}">
                            <img src="{{ asset('assets/images/icon/img.png') }}" alt="Logo" style="height: 90px;">
                        </a>
                    </div>

                    <!-- Reg No and PSIRA (Right) -->
                    <div class="d-flex flex-column align-items-end gap-2">
                        <div class="badge bg-dark rounded-pill px-3 py-2 text-white">
                            REG NO: 2023/000579/07
                        </div>
                        <div class="badge bg-dark rounded-pill px-3 py-2 text-white">
                            PSIRA: 4535023
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom White Section -->
        <div class="header-main-one bg-white" style="padding: 20px">
            <div class="container py-2">
                <div class="d-flex flex-wrap justify-content-between align-items-center text-center text-lg-start gap-3">
                    <div class="d-flex gap-4 align-items-center flex-wrap">
                        <a href="/" class="text-dark fw-bold text-decoration-none">Home</a>
                        <a href="#about-us" class="text-dark fw-bold text-decoration-none">About</a>
                        <a href="#services" class="text-dark fw-bold text-decoration-none">Services</a>
                    </div>

                    <div class="d-flex flex-column flex-sm-row align-items-center gap-3">
                        <div class="single-right email">
                            <div class="d-flex gap-4 align-items-center flex-wrap">
                                <a href="#"><i class="fab fa-facebook-f"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                            </div>
                        </div>
                        <div class="single-right call">
                            <a class="rts-btn menu-block-none" href="#contact-us" style="background-color: #000; color: #e18b14;">
                                Contact Us
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Custom Vision Section -->
    <section class="vision-banner">
        <div class="container-fluid">
            <div class="row align-items-center vision-row">
                <!-- Left Side -->
                <div class="col-md-5 position-relative text-center vision-left">
                    <img src="{{ asset('assets/images/Group 41.png') }}" class="bg-lion" alt="Lion">

                    <div class="vision-overlay">
                        <img src="{{ asset('assets/images/vision.png') }}" class="vision-icon" alt="Vision Icon">

                    </div>
                </div>
                <!-- Right Side -->
                <div class="col-md-5 vision-text text-white">
                    <p>
                        To benchmark security service company,<br>
                        comparable to any best in the industry,<br>
                        and meet international standard<br>
                        of your competition.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Core Values Section -->
    <section class="core-values-section">
        <div class="container-fluid">
            <div class="row align-items-center core-values-row">
                <!-- Left Icon -->
                <div class="col-md-4 text-center icon-column">
                    <img src="{{ asset('assets/images/Core Values.png') }}" class="core-icon" alt="Core Values Icon">
                </div>

                <!-- Right Text -->
                <div class="col-md-8 text-white core-values-text">
                    <h2 class="core-title">OUR CORE VALUES</h2>
                    <p class="core-subtitle"><em>We believe in the following values</em></p>
                    <p>
                        Treat all clients with dignity and respect, Honesty, Loyalty,<br>
                        Professional conduct, Quality customer service<br>
                        Uphold PSIRA requirements and National Legislations
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Latest Services Section -->
    <section id="service" class="latest-services py-5 bg-white">
        <div class="container text-center">
            <h2 class="fw-bold mb-4" style="font-family: 'Orbitron', sans-serif;">OUR LATEST SERVICES</h2>
            <div class="row g-4">
                <div class="col-md-3 col-sm-6">
                    <div class="service-card bg-dark text-white p-4 rounded">
                        <img src="{{ asset('assets/images/Group 9.png') }}" alt="Shield" class="mb-3" style="height: 60px;">
                        <p>Guarding (Armed & Unarmed Security Officers)</p>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="service-card bg-dark text-white p-4 rounded">
                        <img src="{{ asset('assets/images/policemen.png') }}" alt="Dog Handler" class="mb-3" style="height: 60px;">
                        <p>Security Officer (Dog Handler)</p>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="service-card bg-dark text-white p-4 rounded">
                        <img src="{{ asset('assets/images/Group 21.png') }}" alt="Access Control" class="mb-3" style="height: 60px;">
                        <p>Access Control And Other Related Services</p>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="service-card bg-dark text-white p-4 rounded">
                        <img src="{{ asset('assets/images/Group 8.png') }}" alt="Retail" class="mb-3" style="height: 60px;">
                        <p>Retail Services, Mining Security, National Key Point, Events & Banking</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--About us-->
    <section id="about-us"  class="about-loma-section text-white">
        <div class="container">
            <div class="row align-items-center">
                <!-- Text Block -->
            <div class="col-md-8">
                <h4 class="about-title">About Our Company</h4>
                <p class="about-text">
                    LOMA Tactical is part of LOMA Tactical Security. Matabo Phillip Mathekga has seen the need to serve and protect the legacy of people whom he does the business with. It took him many years to plan for his security sector involving a lot of experienced security personnel. Now, LOMA Tactical Security is ready to help South Africa to fight crime and protect.
                </p>
                <p class="about-text">
                    LOMA Tactical Security has started operating as a security company from 2023 in the security sector. LOMA Tactical Security surpasses our competition in meeting the standards of what a security guard company consists of in the industry of today. As a security provider we provide much more than to deter, detect and report. LOMA Tactical Security is the next generation of contract security providers.
                </p>
                <p class="about-text">
                    We know what it takes to keep you and your business safe, but more importantly, we know how to add value to your company by providing superior customer service and attention to detail. We take ownership of every customer's company and property. We are proud of what you and your company have accomplished and ensure that our security guards display that pride to you and your customers through their appearance and attitude.
                </p>
                <p class="about-text">
                    At LOMA Tactical Security we care about our customers and their businesses. We focus on detail that brings your company to the forefront in your industry. At LOMA Tactical Security, we will add value to your company by providing you more than a deterrent. We will provide that first impression and customer service that will set your company ahead of your competition.
                </p>
            </div>

            <!-- Camera Image -->
            <div class="col-md-4 text-center">
                <img src="{{ asset('assets/images/Camera.png') }}" alt="Camera Icon" class="about-icon img-fluid">
            </div>
        </div>
        </div>
    </section>

    <!-- Contact us-->
    <section id="contact-us" class="contact-us-section py-5">
        <div class="container">
            <h4 class="section-title">Contact Us</h4>
            <div class="row g-4 mt-3">
                <!-- Contact Card 1 -->
                <div class="col-md-4">
                    <div class="contact-card">
                        <h5>Phone</h5>
                        <p>081 376 6050<br>064 534 5958</p>
                    </div>
                </div>

                <!-- Contact Card 2 -->
                <div class="col-md-4">
                    <div class="contact-card">
                        <h5>Email</h5>
                        <p>info@lomasecurity.co.za</p>
                    </div>
                </div>

                <!-- Contact Card 3 -->
                <div class="col-md-4">
                    <div class="contact-card">
                        <h5>Address</h5>
                        <p>169 Unit A, Mankweng<br>Polokwane, South Africa</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Our Clients Section -->
    <hr>
    <section id="clients" class="py-5">
        <div class="container text-center">
            <h4 class="section-title">Our Clients</h4>
            <div class="row justify-content-center g-4">
                <div class="col-md-4 col-sm-6 col-10">
                    <div class="client-logo bg-white rounded d-flex align-items-center justify-content-center" style="height: 120px;">
                        <img src="{{ asset('assets/images/clients/mowedi.jpg') }}" alt="Mowedi Projects" class="img-fluid" style="max-height: 80px;">
                    </div>
                </div>
                <div class="col-md-4 col-sm-6 col-10">
                    <div class="client-logo bg-white rounded d-flex align-items-center justify-content-center" style="height: 120px;">
                        <img src="{{ asset('assets/images/clients/realotcha.jpg') }}" alt="Realotcha Music" class="img-fluid" style="max-height: 80px;">
                    </div>
                </div>
                <div class="col-md-4 col-sm-6 col-10">
                    <div class="client-logo bg-white rounded d-flex align-items-center justify-content-center" style="height: 120px;">
                        <img src="{{ asset('assets/images/clients/kasi-carwash.jpg') }}" alt="Kasi Junxion Car Wash" class="img-fluid" style="max-height: 80px;">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Footer Section -->
    <section id="footer" class="footer-loma-section py-5 bg-dark text-white">
        <div class="container text-center">
            <div class="row justify-content-center g-4 mb-3">
                <div class="col-md-4 col-sm-6 col-10">
                    <div>
                        <img src="{{ asset('assets/images/footer/psira.jpg') }}" alt="Mowedi Projects" class="img-fluid" style="max-height: 80px;">
                    </div>
                </div>
                <div class="col-md-4 col-sm-6 col-10">
                    <div>
                        <img src="{{ asset('assets/images/footer/psspf.jpg') }}" alt="Realotcha Music" class="img-fluid" style="max-height: 80px;">
                    </div>
                </div>
            </div>
            <p class="mb-0" style="font-size: 14px;">
                Designed by <strong>Robo-Technologies</strong> &copy; {{ date('Y') }}
            </p>
        </div>
    </section>

    <style>

        /* Force flex layout on header rows */
        .header-main-one .container > .d-flex {
            display: flex !important;
            flex-wrap: nowrap !important;
            justify-content: space-between;
            align-items: center;
            flex-direction: row;
        }

        /* Make sure left and right sections take up equal or auto space */
        .header-main-one .thumbnail {
            flex-shrink: 0;
        }

        .header-main-one .d-flex.flex-column {
            flex-shrink: 0;
        }

        /* Prevent wrapping on smaller screens */
        @media (max-width: 768px) {
            .header-main-one .container > .d-flex {
                flex-wrap: nowrap !important;
                flex-direction: column;
                gap: 1rem;
            }

            .header-main-one .d-flex.flex-column {
                align-items: center !important;
            }

            .header-main-one .d-flex.flex-wrap {
                flex-wrap: nowrap !important;
            }
        }

        .vision-banner {
            background-color: #140a02;
            padding: 60px 0;
        }

        .vision-row {
            display: flex;
            flex-wrap: nowrap; /* changed from wrap to nowrap */
            justify-content: space-between;
            align-items: center;
            position: relative;
        }

        .bg-lion {
            position: absolute;
            top: -45%;
            left: 1px;
            width: 66%;
            opacity: 0.1;
            z-index: 1;
        }

        .vision-overlay {
            position: relative;
            z-index: 2;
        }

        .vision-icon {
            width: 40%;
            margin-bottom: 10px;
        }

        .divider-lightning {
            max-width: 100px;
            height: auto;
        }

        .vision-text {
            padding: 30px;
            flex: 1;
            z-index: 2;
        }

        .vision-text p {
            font-size: 18px;
            line-height: 1.8;
            color: white;
            text-align: left;
            font-weight: 400;
        }

        .vision-left,
        .vision-text {
            flex: 1 1 50%;
            max-width: 50%;
        }

        @media (max-width: 768px) {
            .vision-row {
                flex-wrap: wrap; /* fallback to column on smaller screens */
                text-align: center;
            }

            .vision-left,
            .vision-text {
                flex: 1 1 100%;
                max-width: 100%;
            }

            .vision-text p {
                text-align: center;
            }
        }

        /*Core values*/
        .core-values-section {
            background-color: #e18b14;
            padding: 60px 0;
            position: relative;
            overflow: hidden;
        }

        .core-values-section::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            background-image: url('{{ asset("assets/images/Group 41.png") }}');
            background-repeat: no-repeat;
            background-position: center right;
            background-size: contain;
            opacity: 0.05; /* Lower opacity for soft faded look */
            z-index: 0;
            transition: opacity 1.2s ease-in-out;
        }

        .core-values-row {
            position: relative;
            z-index: 1;
        }

        .icon-column .core-icon {
            z-index: 1;
            position: relative;
        }

        .core-values-text {
            position: relative;
            z-index: 1;
        }


        .core-values-row {
            display: flex;
            align-items: center;
            justify-content: center;
            flex-wrap: nowrap;
        }

        .icon-column .core-icon {
            max-width: 150px;
            height: auto;
            margin: 0 auto;
        }

        .core-values-text {
            padding: 20px 30px;
        }

        .core-title {
            font-weight: 800;
            font-size: 30px;
            margin-bottom: 10px;
        }

        .core-subtitle {
            font-style: italic;
            font-weight: 500;
            margin-bottom: 10px;
        }

        .core-values-text p {
            font-size: 16px;
            font-weight: 400;
            line-height: 1.8;
            color: #fff;
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .core-values-row {
                flex-wrap: wrap;
                text-align: center;
            }

            .core-values-text {
                padding: 30px 20px;
            }

            .core-title {
                font-size: 24px;
            }

            .core-subtitle,
            .core-values-text p {
                font-size: 14px;
            }
        }
        /*Services*/
        .core-values-section p {
            font-size: 16px;
            line-height: 1.7;
            font-weight: 400;
        }
        .service-card {
            background-color: #e18b14; /* Optional: matches your brand orange */
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            flex: 1 1 220px;
            max-width: 366px;
            min-height: 280px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }

        .service-card img {
            width: 70px;
            height: 70px;
            object-fit: contain;
            margin-bottom: 15px;
        }

        .service-card p {
            margin: 0;
            font-weight: 500;
            font-size: 15px;
            color: #ffffff; /* Text in white */
        }

        .service-card:hover {
            transform: translateY(-5px);
        }

        /*About us */
        .about-loma-section {
            background-color: #1a1005; /* dark brown */
            padding: 60px 0;
        }

        .about-title {
            color: #f39200; /* bold orange heading */
            font-weight: 600;
            margin-bottom: 20px;
        }

        .about-text {
            font-size: 15px;
            color: white;
            line-height: 1.8;
            margin-bottom: 15px;
        }

        .about-icon {
            max-width: 150px;
            margin-top: 20px;
        }

        /* Contact Us */
        .contact-us-section {
            background-color: #fff;
        }

        .section-title {
            font-weight: 700;
            color: #1a1005;
        }

        .contact-card {
            background-color: #e18b14;
            border-radius: 10px;
            padding: 30px 20px;
            text-align: center;
            --color-text: #fff;
            height: 100%;
            transition: transform 0.3s ease;
        }

        .contact-card h5 {
            font-weight: 600;
            margin-bottom: 10px;
        }

        .contact-card:hover {
            transform: translateY(-5px);
        }

        .client-logo {
            height: 180px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .client-logo img {
            max-height: 100%;
            max-width: 100%;
            object-fit: contain;
        }

        /*Footer */
        .footer-loma-section {
            background-color:  #1a1005; /* dark brown */
            padding: 60px 0;
        }


    </style>
@endsection
